/* Blinker Demo */
/* Modfified code by William Gibb */
/* Contains four different POV toys	*/
/* Comment out toys from the while(1) loop*/
/* to disable them*/

/*	Toy 1 - a diamond outline  	*/
/* 	Toy 2 - a filled diamond	*/
/* 	Toy 3 - a trapezoid			*/
/* 	Toy 2 - a smiley face		*/

/* 	Toy 1 shows bitwise maniuplation */
/* 	Toy 2 shows the use of a character array with a fixed length	*/
/* 	Toys 3 and 4 show the use of a variable length character array	*/


#include <avr/io.h>		/* Defines pins, ports, etc */
#define F_CPU 8000000UL	        /* Sets up the chip speed for delay.h */
#include <util/delay.h>		/* Functions to waste time */

#define WAIT 4
#define ITER 100

void main(void){
int i = 0;
int j = 0;
unsigned char diamond[8]={0x00, 0x18, 0x3C, 0x7E, 0xFF, 0x7E, 0x3C, 0x18};
unsigned char trapezoid[]={0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF, 0xFF, 0xFE, 0xFC, 0xF8, 0xF0, 0xE0, 0xC0, 0x80};
unsigned char smiley[]={0x00, 0x3C, 0x42, 0x81, 0xA5, 0x81, 0xA5, 0xBD, 0x42, 0x3C };
DDRB = 0xff;

 PORTB = 0;		       /* Turn off everything(!) on PORTB */
_delay_ms(WAIT);		/* wait */
	
  while(1){			/* the main loop, from which we never return */
	j = ITER;
	while (j!=0)
	{
		for(i=0; i<8; i++)
		{
		PORTB = (1 <<(7-i))| (1 << i);
	   _delay_ms(WAIT);		/* wait */	
		}
		j--;
	}

	j = ITER;
	while (j!=0)
	{
		for(i=0; i<8; i++)
		{
			PORTB = diamond[i];
	   		_delay_ms(WAIT);		/* wait */	
		}
		j--;		
	}
	j = ITER;
	while (j!=0)
	{
		for(i=0; i<sizeof(trapezoid); i++)
		{
			PORTB = trapezoid[i];
	   		_delay_ms(WAIT);		/* wait */	
		}
		j--;		
	}
	j = ITER;
	while (j!=0)
	{
		for(i=0; i<sizeof(smiley); i++)
		{
			PORTB = smiley[i];
	   		_delay_ms(WAIT);		/* wait */	
		}
		j--;		
	}


  }
}

