/* Quick Demo of (blocking) serial input.
   Send a number 0-7 on the keyboard, turns it into a bit value,
   lights up LED number whatever.
*/

#include <inttypes.h>
#include <avr/io.h>
#define F_CPU  8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"


void main(void){
  char input;
  char i;

  /* Blink LEDs quickly 8 times to verify they're working */
  DDRB = 0xff;			/* all set to output */
  for (i=0; i<8; i++){
    PORTB = 0xff;
    _delay_ms(100);
    PORTB = 0x00;
    _delay_ms(100);
  }
  
  /* Initialize and test */
  initUART();
  sayOK();


  while(1){			/* mainloop */

    input = receiveByte();	/* wait for input */
    transmitByte(input);	/* echo it back */

    if (input >= '0' & input <= '7'){ 
      PORTB = _BV(input - '0'); /* This is a very useful trick.
				   Single quotes in C results in the
				   ASCII value of the character. */
    }

    else {			/* turn 'em all off */
      PORTB = 0;
    }

  } /* end mainloop */

}
