#!/usr/bin/env python

## A simple routine for demonstrating serial output from python.  

## The AVR is programmed with a routine that displays the characters
## '0' through '7' on a single LED

## Requires serialLED firmware.  Double-check for many short blinks on init.

## Cycling through the characters gives us cylon eyes.  Woot.


import serial, time, struct

BAUDRATE = 9600
PORT = '/dev/ttyUSB0'

serialPort = serial.Serial(PORT, BAUDRATE, timeout=10)
serialPort.flushOutput()

leds = ['0','1','2','3','4','5','6','7']

for i in range(1000):
    for j in range(7):
        serialPort.write(leds[j])
        time.sleep(0.1)

    for j in range(7):
        serialPort.write(leds[7-j])
        time.sleep(0.1)



    



  

