#!/usr/bin/env python

## Quick demo of taking info from your computer and displaying it on the AVR
## AVR is set up to display the raw byte value on 8 LEDs

## Reads cpu load (on Linux systems) and displays it out on the LEDs

## Requires serialLED firmware: displays the ascii value of the byte directly 
## Check for 2 long blinks on init.

## Don't think this works, but I'm sure someone else can fix it.  Open Source!

import serial, time, struct, urllib, re

BAUDRATE = 9600
PORT = '/dev/ttyUSB0'

serialPort = serial.Serial(PORT, BAUDRATE, timeout=10)
serialPort.flushOutput()


def packByte(byte):
    '''Takes an integer and turns it into an unsigned byte value in order
to send it over the serial line '''
    return(struct.pack("B", byte))
               

def barGraph(xPercent):
    '''Turns a percentage into a byte that displays nicely on an 8-bit bar
graph'''
    x = int((xPercent+0.0625) * 100 / 12.5) # convert percentage to
                                            # centered 0-8 range
    bar = [2**i-1 for i in range(9)]   # [0, 1, 3, 7, 15, 31, 63, 127, 255]
    byte = packByte(bar[x])  
    return(byte)


## CPU Load meter:

lastValues = [0,0,0,0]
runningLoad = 0
for i in range(1000):
    # Read in the cpu load over the last minute
    status = open("/proc/stat").readlines()
    cpuString = [x for x in status if x.startswith("cpu ")][0]
    cpuValues = cpuString.split()
    
    theseValues = [int(x) for x in cpuValues[1:5]] # user, nice, system, idle  
    valueDiffs = [theseValues[i] - lastValues[i] for i in range(4)]
    ## Store and move on
    lastValues = theseValues

    cpuLoad = sum(valueDiffs[0:3]) / (sum(valueDiffs) + 0.0)
    runningLoad = 0.5 * runningLoad + 0.5 * cpuLoad # smoothing
    serialPort.write(barGraph(runningLoad))
    time.sleep(0.25)
    

    

    



  

