/* 
   Demo of the simple on/off button code, transmitting over serial. 
*/

#include <inttypes.h>
#include <avr/io.h>
#define F_CPU  8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"


#define INPUT_PIN     PD2
#define INPUT_PORT    PORTD
#define INPUT_DDR     DDRD
#define INPUT_INPUT   PIND     

#define LED_DDR       DDRB
#define LED_PORT      PORTB
#define LED           PB3

void main(void){
  
  INPUT_PORT = _BV(INPUT_PIN);/* initialize pullup resistor on our input pin */
  LED_DDR = 0b11111111;

  initUART();
  sayOK();
  uint8_t accumulator;

  while(1){                     /* mainloop */    
    
    /* light up when button pressed */
    if ((INPUT_INPUT & _BV(INPUT_PIN)) == 0){       /* pin is negative logic */
      if (accumulator < 255){
	accumulator++;
      }
    }
    else{
      if (accumulator > 0){
	accumulator--;
      }
    }
    
    transmitByte(accumulator);
    _delay_ms(10);
    LED_PORT = _BV(accumulator >> 5);  // 8 bits shifted right by 5 = 3 bits = 8 values

  } /* end mainloop */
  
}
