/* Quick Demo of (blocking) serial input.
   Send a number 0-7 on the keyboard, turns it into a bit value,
   lights up LED number whatever.
*/

#include <inttypes.h>
#include <avr/io.h>
#define F_CPU  8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"

#define BLINK 0			/* controls whether or not to blink
				   between received characters */

void main(void){
  char input;

  /* Blink LEDs 2x slowly to verify they're working */
  DDRB = 0xff;			/* all set to output */
  PORTB = 0xff;
  _delay_ms(500);
  PORTB = 0x00;
  _delay_ms(500);
  PORTB = 0xff;
  _delay_ms(500);
  PORTB = 0x00;
  _delay_ms(500);
  
  /* Initialize and test */
  initUART();
  sayOK();


  while(1){			/* mainloop */

    input = receiveByte();	/* wait for input */
    transmitByte(input);	/* echo it back */

    
    PORTB = 0;    /* All LEDs off for short period. */

#if BLINK
    _delay_ms(50);  /* Cosmetic, but I like the feeling of
		       feedback the blinking provides. */
#endif
    
    PORTB = input; 		/* NOT the BV, but the ascii value of
				   the character */ 
    

  } /* end mainloop */

}
