/* PWM Demo */

#include <avr/io.h>		/* Defines pins, ports, etc */
#define F_CPU 8000000UL	   /* Sets up the chip speed for delay.h */
#include <util/delay.h>		/* Functions to waste time */


int main(void){
  uint8_t counter;
  uint8_t i;
  
  // uint8_t brightnessArray[] = {10,  45,  80, 115, 150, 185, 220, 255}; /* linear range */
  uint8_t brightnessArray[] = {2, 4, 8, 16, 32, 64, 128, 255}; /* powers of two */
  
  // Init "section"
  DDRB = 255;			/* set all up as output */

  // Main loop  
  while(1){			/* the main loop, from which we never return */

    PORTB = 255;		/* all lights on */
    
    for (counter=0; counter < 255; counter++){
      _delay_us(20);
      
      for (i = 0; i < 8; i++){	/* loop over LEDs */
        if (counter > brightnessArray[i]){
          PORTB &= ~_BV(i);
        }
      }

    }

  } // end main loop  
  return(0);			/* never reached */
}  // end main

