/* PWM Demo */

#include <avr/io.h>		/* Defines pins, ports, etc */
#define F_CPU 8000000UL	   /* Sets up the chip speed for delay.h */
#include <util/delay.h>		/* Functions to waste time */

int main(void){
  uint8_t brightness, j;

  
  DDRB = 0xff;			/* all set for output */
  
  while(1){			/* the main loop, from which we never return */

    for (brightness = 0; brightness < 255; brightness++){	/* fade in */
      PORTB = 255; 	/* all lights on */
      for (j=0; j < 255; j++){
	_delay_us(10);
	if (j > brightness){
	  PORTB = 0; 	/* all light off */
	}
      }
    } /* end fade in */

    for (brightness = 255; brightness > 0; brightness--){	/* fade out */
      PORTB = 0b11111111; 	/* all light on */
      for (j=0; j < 255; j++){
	_delay_us(10);
	if (j > brightness){
	  PORTB = 0; 	/* all light off */
	}
      }
    } /* end fade in */
  }
  return(0);			/* never reached */
}
