
// ---------------
//   Pin Defines  
// ---------------

#define BUTTON                     PD2
#define BUTTON_PORT                PORTD
#define BUTTON_PIN                 PIND
#define BUTTON_DDR                 DDRD
#define BUTTON_SET_OUTPUT          BUTTON_DDR |= _BV(BUTTON)
#define BUTTON_SET_INPUT           BUTTON_DDR &= ~_BV(BUTTON)
#define BUTTON_ON                  BUTTON_PORT |= _BV(BUTTON)
#define BUTTON_OFF                 BUTTON_PORT &= ~_BV(BUTTON)
#define BUTTON_TOGGLE              BUTTON_PORT ^= _BV(BUTTON)
#define BUTTON_IS_HIGH             (BUTTON_PIN & _BV(BUTTON))
#define BUTTON_IS_LOW              !(BUTTON_PIN & _BV(BUTTON))

#define ADC                     PC0
#define ADC_PORT                PORTC
#define ADC_PIN                 PINC
#define ADC_DDR                 DDRC
#define ADC_SET_OUTPUT          ADC_DDR |= _BV(ADC)
#define ADC_SET_INPUT           ADC_DDR &= ~_BV(ADC)
#define ADC_ON                  ADC_PORT |= _BV(ADC)
#define ADC_OFF                 ADC_PORT &= ~_BV(ADC)
#define ADC_TOGGLE              ADC_PORT ^= _BV(ADC)
#define ADC_IS_HIGH             (ADC_PIN & _BV(ADC))
#define ADC_IS_LOW              !(ADC_PIN & _BV(ADC))

#define LED                     PB0
#define LED_PORT                PORTB
#define LED_PIN                 PINB
#define LED_DDR                 DDRB
#define LED_SET_OUTPUT          LED_DDR |= _BV(LED)
#define LED_SET_INPUT           LED_DDR &= ~_BV(LED)
#define LED_ON                  LED_PORT |= _BV(LED)
#define LED_OFF                 LED_PORT &= ~_BV(LED)
#define LED_TOGGLE              LED_PORT ^= _BV(LED)
#define LED_IS_HIGH             (LED_PIN & _BV(LED))
#define LED_IS_LOW              !(LED_PIN & _BV(LED))

