#include <avr/io.h>
#include <avr/interrupt.h>
#define F_CPU 8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"
#include "pinDefines.h"

int main(void){

  uint16_t adcValue;
  uint8_t i;

  /* Set up the ADC */


  ADMUX |= _BV(ADLAR); 
				/* left-shift for easy 8 bit samples, p. 259 */
  DIDR0 |= _BV(ADC5D); 
				/* turn off digital input buffer on ADC5, p. 260 */
  ADCSRA = _BV(ADEN) | _BV(ADATE) | _BV(ADSC); 
				/* ADC enable, auto-trigger enable, 
				   start conversions,  p. 258*/
  //  ADMUX = _BV(MUX0) | _BV(MUX2); /* sample on ADC5, p. 257 */
  //  Don't need to explicitly call this b/c ADC0 / PC0 is the default

  initUART();
  sayOK();

  LED_DDR = 0xff; 		/* set all LEDs for output */
  
  while(1){

    _delay_ms(100);

    // Oversampling code 
    adcValue = 0;
    for (i=0; i<8; i++){
      while( !(ADCSRA & _BV(ADSC)) ){
	; /* do nothing until the ADSC bit is set low again, 
	     signalling the end of the last ADC conversion, see p. 264 */
      }
      adcValue += ADCH;		/* sum up 8 values */
    }
    adcValue = adcValue >> 3; 		/* divide by 2^3 = 8 */
    
    // And write it out
    transmitByte(adcValue);
    LED_PORT = _BV(adcValue >> 5);
    
  } /* end mainloop */


  return(1);
} /* end main */
