#include <avr/io.h>
#include <avr/interrupt.h>
#define F_CPU 8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"
#include "pinDefines.h"


void displayBargraph(uint8_t byte){
  uint8_t i;
  LED_PORT = 0;			/* start all lights off */
  byte = byte >> 5; 		/* this is a trick to use only the 3 
				   most-significant bits 
				   so we can display them on a scale of 1-8 */
  for (i = 0 ; i < byte; i++){ 	/* light them all up */
    LED_PORT |= _BV(i); 
  }
}

int main(void){

  uint8_t adcValue;
  uint8_t i;

  /* Set up the ADC */
  ADMUX |= _BV(ADLAR); 
				/* left-shift for easy 8 bit samples, p. 259 */
  DIDR0 |= _BV(ADC5D); 
				/* turn off digital input buffer on ADC5, p. 260 */
  ADCSRA = _BV(ADEN) | _BV(ADATE) | _BV(ADSC); 
				/* ADC enable, auto-trigger enable, start conversions,  p. 258*/
  ADCSRA |= _BV(ADPS0) | _BV(ADPS1) | _BV(ADPS2);
				/* set ADC clock prescaler do sample every 128 cycles, p. 264,5 */
  
  initUART();
  sayOK();

  LED_DDR = 0xff; 		/* set all LEDs for output */
  
  while(1){

    _delay_ms(100); 
    adcValue = ADCH;

    transmitByte(adcValue);
    displayBargraph(adcValue);

    
  } /* end mainloop */


  return(1);
} /* end main */
