#!/usr/bin/env python

# 
# microTweeter program
# by William gibb @ Hacdc
# williamgibb [aT] gmail dit com
# www.hacdc.org / wiki.hacdc.org
#
# An exercise in learning how to program twitter and play with a microcontroller
#
# This script is covered under the following license
# Creative commons Attribution Noncommercial Share alike 3.0 license
# license link http://creativecommons.org/licenses/by-nc-sa/3.0/us/
# Unless specificed otherwise inline
#

import serial
import random
import sys
import os
import getopt
import ConfigParser
import twitter


USAGE = ''' 
Program for autotweeting when a microcontroller gives it some serial datas.
use me with the following

<program name> -f[--file] <filename> -p[--port] <serial port>

--file chooses a file used to populate a set of quotes to tweet.
--port chooses which serial port to look at for random bits

this requires the user to have setup pytwitter's ~/.tweetrc

'''

def PrintUsageAndExit():
	print USAGE
	sys.exit(2)

#
# TweetRc class came from pyTwitter project
# http://code.google.com/p/pytwitter/
# This class is covered under an Apache 2.0 license
#	
class TweetRc(object):
	def __init__(self):
		self._config = None
				
	def GetConsumerKey(self):
		return self._GetOption('consumer_key')

	def GetConsumerSecret(self):
		return self._GetOption('consumer_secret')

	def GetAccessKey(self):
		return self._GetOption('access_key')

	def GetAccessSecret(self):
		return self._GetOption('access_secret')
	
	def _GetOption(self, option):
		try:
			return self._GetConfig().get('Tweet', option)
		except:
			return None

	def _GetConfig(self):
		if not self._config:
			self._config = ConfigParser.ConfigParser()
			self._config.read(os.path.expanduser('~/.tweetrc'))
		return self._config	

def main():
	'''Main function for the program'''
	#Init args
	if (len(sys.argv) != 5):
		PrintUsageAndExit()
	try:
		shortflags = 'f:p:'
		longflags = ['file=','port=']
		opts, args = getopt.getopt(sys.argv[1:], shortflags, longflags)
	except getopt.GetoptError:
		PrintUsageAndExit()
	print "printing opts"
	print opts
	for o, a in opts:
		if o in ("-f","--file"):
			fin = a
		if o in ("-p","--port"):
			port = a	
	#init rand, open serial port, open file
	print "i'm loading"
	random.seed()
	serialPort = serial.Serial(port, 9600, timeout=10)
	print "opened serial port"
	print fin
	try:
		f=open(fin,"r")
	except NameError:
		print "File did not exist!"
		print "Compute smarter!"
		sys.exit(2)
	quotes = []
	for line in f:
		quotes.append(line)
	f.close()
	print "read in quotes file"
	#setup twitter
	rc = TweetRc()
	consumer_key = rc.GetConsumerKey()
	consumer_secret = rc.GetConsumerSecret()
	access_key = rc.GetAccessKey()
	access_secret = rc.GetAccessSecret()
	if not consumer_key or not consumer_secret or not access_key or not access_secret:
		print "Twitter setup failed"
		print "Did you setup your ~/.tweetrc file?"
		sys.exit(2)
	encoding = None
	api = twitter.Api(consumer_key=consumer_key, consumer_secret=consumer_secret, access_token_key=access_key, access_token_secret=access_secret, input_encoding=encoding)
	# now make magic happen
	while(1):
		serialPort.flushInput()
		try:
			value = ord(serialPort.read())
		except TypeError:
			print "shit blew up"
			continue
		print "read in value: ", value
		random.getrandbits(value)
		message=random.choice(quotes)
#		print message
		try:
			status = api.PostUpdate(message)
		except UnicodeDecodeError:
			print "Your message could not be encoded.  Perhaps it contains non-ASCII characters? "
			print "Try explicitly specifying the encoding with the --encoding flag"
			sys.exit(2)
		print "%s just posted: %s" % (status.user.name, status.text)
		
if __name__ == "__main__":
	main()


