/* 
   microTweeter
   william gibb @ hacdc
   williamgibb [a7] gmail dit com


   Code cribbed from elliot williams 	
   "Demo of a simple way to do button presses"
   it is probably licensed with some sort of creative commons license..



*/

#include <inttypes.h>
#include <avr/io.h>
#define F_CPU  8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"


#define BUTTON_PIN     PD2
#define BUTTON_PORT    PORTD
#define BUTTON_DDR     DDRD
#define BUTTON_INPUT   PIND     

#define OUTPUT_PORT PORTB
#define OUTPUT_DDR  DDRB

#define DEBOUNCE_WAIT  1		/* milliseconds */
#define WAIT  1		/* milliseconds */

/* Global variable */
uint8_t led = 0;

static inline void incrementLED(void){
  if (led == 7){
    led = 0;			/* wrap around */
  }
  else if (led < 7){
    led++;			/* or count up */
  }
  OUTPUT_PORT = _BV(led);	/* and display */
}

void main(void){
  initUART();
  sayOK();
  uint8_t accumulator=0;
  uint8_t buttonState=0;

  BUTTON_PORT = _BV(BUTTON_PIN);/* initialize pullup resistor on our input pin */
  OUTPUT_DDR = 0xff;	  /* set up LEDs for output */

  /* blink all as a sanity check */
  OUTPUT_PORT = 0xff;
  _delay_ms(100);
  OUTPUT_PORT = 0x00;
  _delay_ms(200);


  while(1){                     /* mainloop */    
	accumulator++;
    _delay_ms(WAIT);

    if (!(BUTTON_INPUT & _BV(BUTTON_PIN)) & !buttonState){ /* pin is negative logic */
      _delay_ms(DEBOUNCE_WAIT);
      if (!(BUTTON_INPUT & _BV(BUTTON_PIN))){
	  incrementLED();
		transmitByte(accumulator);
	  buttonState = 1;
      }
    }      
    
    /* Turn button state off after a delay in off state */
    if ((BUTTON_INPUT & _BV(BUTTON_PIN))){
      _delay_ms(DEBOUNCE_WAIT);
      if ((BUTTON_INPUT & _BV(BUTTON_PIN))){
	buttonState = 0;
      }
    }

  } /* end mainloop */
  
}
