#!/usr/bin/env python

import serial

def readValue(serialPort):
    serialPort.flushInput()
    return(ord(serialPort.read()))

def plotValue(value, scaleMin, scaleMax):
    """
 	Displays the value on a scaled scrolling bargraph
    """
    value = int(value)
    scaleMin = int(scaleMin)
    scaleMax = int(scaleMax)
    print "%s%3i" % (("-"*((value-scaleMin)*77 / (scaleMax-scaleMin))), value)
    

def cheapoScope(serialPort, scaleMin, scaleMax, smoothing):
    runningValue = 0.0
    while(1):
        runningValue = float(readValue(serialPort)) + smoothing*runningValue
	plotValue(runningValue*(1.0 - smoothing), scaleMin, scaleMax)
        

if __name__ == "__main__":

    import sys
    if len(sys.argv) == 4:
        scaleMin, scaleMax, smoothing = [float(x) for x in sys.argv[1:4]]
    else:
        scaleMin, scaleMax, smoothing = (0, 256, 0.5)
        

    serialPort = serial.Serial('/dev/ttyUSB0', 57600, timeout=10)
    cheapoScope(serialPort, scaleMin, scaleMax, smoothing)



    



  

