
/*  i2c_experiments: Accelerometer   */


#ifndef STANDARD_HEADERS
#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/sleep.h> 
#define STANDARD_HEADERS
#endif

#define F_CPU 1000000UL
#include <util/delay.h>

// #define BAUDRATE 9600
#define BAUDRATE 57600
#include "USART48.h"


// Pin Defines           ------------------------------------------------

#define SCL  PC5
#define SDA  PC4

/* Addresses: See page 19 of LIS302D Datasheet */
#define LIS302D_ADDRESS  0x1C 	/* 001 1100    note 7 bits */
#define LIS302D_READ     0x39	/* 001 11001   address + R */
#define LIS302D_WRITE    0x38	/* 001 11000   address + W */

/* Registers and Commands: See page 24 of LIS302D Datasheet */
#define LIS302D_WHOAMI    0x0f
#define LIS302D_STATUS    0x27
#define LIS302D_OUTX      0x29
#define LIS302D_OUTY      0x2b
#define LIS302D_OUTZ      0x2d

#define LIS302D_CTRL_REG1     0x20
#define LIS302D_POWERDOWN_BIT 6

// #define DEBUG_MODE   1



inline void i2cWaitForComplete(void){
  while( !(TWCR & _BV(TWINT)) );
#ifdef DEBUG_MODE
  transmitByte(TWSR);
#endif
}

inline void i2cSendStart(void){
  TWCR = (_BV(TWINT)| _BV(TWSTA) | _BV(TWEN));
  i2cWaitForComplete();
}

inline void i2cSend(void){
  TWCR = (_BV(TWINT)| _BV(TWEN));
  i2cWaitForComplete();
}

inline void i2cSendStop(void){
  TWCR = (_BV(TWINT) | _BV(TWSTO) | _BV(TWEN));
}

uint8_t getRegister(uint8_t whichRegister){
  
  i2cSendStart();
  TWDR = LIS302D_WRITE;		/* MT mode, address packet */
  i2cSend();

  TWDR = whichRegister;		/* MT mode, register packet */
  i2cSend();

  i2cSendStart();		/* repeated start */
  TWDR = LIS302D_READ;		/* MR mode, address packet + R */
  i2cSend();		       

  i2cSend();			/* give slave the go-ahead */
  whichRegister = TWDR;		/* read value, re-use variable */

  i2cSendStop();		/* done */

  return(whichRegister);
}

void setRegister(uint8_t whichRegister, uint8_t value){
  
  i2cSendStart();
  TWDR = LIS302D_WRITE;		/* MT mode, address packet */
  i2cSend();

  TWDR = whichRegister;		/* MT mode, register packet */
  i2cSend();

  TWDR = value;			/* Data packet */
  i2cSend();

  i2cSendStop();		/* done */
}


inline void init(void){
  /* Get UART up */
  initUART();
  sayOK();
  
  /* Init up the I2C */
  PORTC |= _BV(SCL) | _BV(SDA);       /* set up pins for output */
  TWBR = 0x0b;			      /* set bit rate, see pg. 221 */
  
  /* Turn accelerometer on */
  setRegister(LIS302D_CTRL_REG1, _BV(LIS302D_POWERDOWN_BIT));
    
#ifdef DEBUG_MODE   
  /* Test with a WHOAMI, expecting 3b */
  transmitByte(getRegister(LIS302D_WHOAMI));
#endif
}




int main(void){
   uint8_t i;

   init();
   
   while(1){
     
     i = getRegister(LIS302D_OUTX);
     transmitByte(i+127);	        /* centers in the middle  */
     
#ifdef DEBUG_MODE
     for (i=0; i<200; i++){
#endif
       _delay_ms(20);
#ifdef DEBUG_MODE
     }
#endif

   } /* end while */
}    /* end main */

