/* Simple use of timer0 for PWM */

#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#define F_CPU 1000000UL
#include <util/delay.h>


#define LED      PB0

void init(void){
  /* set up pins for output */
  DDRB |= _BV(LED);

  /* flash LED to double-check */
  uint8_t i;
  for (i = 0 ; i <=3 ; i++){
    PORTB |= _BV(LED);
    _delay_ms(200);
    PORTB &= ~_BV(LED);
    _delay_ms(200);
  }
  
  /* setup counter, p. 109 */
  TCCR0B |= _BV(CS00);		/* set up timer prescale */
  TIMSK0 |= _BV(TOIE0);		/* enable overflow interrupt */
  TIMSK0 |= _BV(OCIE0A);		/* enable output compare interrupt */
  
  sei();
}


ISR(SIG_OVERFLOW0){
  PORTB |= _BV(LED);		/* on at overflow */
}

ISR(SIG_OUTPUT_COMPARE0A){
  PORTB &= ~_BV(LED);  		/* off at compare match */
}




/* Main program */
int main(void){
  uint8_t i;

  init();
  
  while(1){			/* mainloop */
    
    for (i = 0; i < 5; i++){	/* ramp up */
      OCR0A = i * 50 + 5;
      _delay_ms(100);
    }

    for (i = 5; i >= 1; i--){	/* ramp down */
      OCR0A = i * 50 + 5;
      _delay_ms(100);
    }
    
  }				/* end mainloop */
  return(1);
} /* end main */

