
/* Serial-enabled, interrupt-driven bogus example. */

#include <avr/io.h>		/* Defines pins, ports, etc */

#define F_CPU 1000000UL	      /* Sets up the chip speed for delay.h */
#include <util/delay.h>		/* Functions to waste time */

#define BAUDRATE  4800
#include "USART48.h"		/* uses BAUDRATE, so define it first */

#include <avr/interrupt.h>

ISR(USART_RX_vect){
  transmitByte('\n');
  transmitByte('\n');
  transmitByte(UDR0);
  transmitByte('\n');
  transmitByte('\n');
  _delay_ms(100);
  _delay_ms(100);
}


int main(void){
  
  uint8_t i, letter;
  
  initUART();
  sayOK();
  
  /* Setup serial interrupt here */
  UCSR0B |= _BV(RXCIE0);	/* turn on receive interrupt vector */
  sei();			/* set interrupts enable */
  
  while(1){

    for (letter = 'A'; letter <= 'Z'; letter++){
      transmitByte(letter);
      
      _delay_ms(100);
      _delay_ms(100);
    }
    transmitByte('\n');    

  } /* end while */
}   /* end main */
