/* One-Key Audio Organ */

#include <avr/io.h>		/* Defines pins, ports, etc */
#define F_CPU 1000000UL	      /* Sets up the chip speed for delay.h */
#include <util/delay.h>		/* Functions to waste time */
#include "scale.h"		/* Include nice note definitions */

#define SPEAKEROUT   PB6
#define BUTTON       PB0
#define BUTTONTIME   500

int main(void){

  uint8_t i=0, j=0;

  uint8_t buttonPressed=0;
  uint8_t maryHadLittleLamb[] = {C2, 
				 E1, D1, C1, D1, E1, E1, E1, 
				 D1, D1, D1, E1, G1, G1, 
				 E1, D1, C1, D1, E1, E1, E1, 
				 E1, D1, D1, E1, D1, C1};
 

  DDRB = _BV(SPEAKEROUT);	/* set up for output on SPEAKER */
  PORTB = _BV(BUTTON);		/* enables pullup on button */

  while(1){			/* mainloop */

    _delay_us(7);		/* around 10uS per loop */
    i++;			/* i = i + 1; */
    
    if (buttonPressed){
      if (i == maryHadLittleLamb[j]){ 
	i = 0;
	PORTB ^= _BV(SPEAKEROUT);	
      }    
      if (PINB & _BV(BUTTON)){ 	/* button released */
	buttonPressed = 0;
      }
    }

    else {			/* if not pressed, look for presses */
      if (~PINB & _BV(BUTTON)){ /* see button */
	_delay_us(BUTTONTIME);	/* wait */
	if (~PINB & _BV(BUTTON)){ /* if see it again, it's a valid press */
	  buttonPressed = 1;
	  j++;		       /* step to the next note in the song */
	  j = j % 27;	   /* wrap around if needed (% is "modulo") */
	}
      }
    }
    
    
    
  }				/* end while(1) */
  return(0);			/* never reached */
}
