/* Using the counter and an interrupt for PWM */

#include <avr/io.h>	      /* Defines pins, ports, etc */
#define F_CPU 8000000UL       /* Sets up the chip speed for delay.h */
#include <util/delay.h>	      /* Functions to waste time */
#define BAUDRATE  9600
#include "USART88.h"	       /* uses BAUDRATE, so define it first */
#include <avr/interrupt.h>
#include "pinDefines.h"
#include "commonInits.h"


volatile uint8_t timerClicks;
volatile uint8_t pwm;
volatile uint8_t updown;

ISR(TIMER1_OVF_vect){		/* on overflow, do stuff.  timebase. */

  if (timerClicks == 10){
    pwm++;
    if (pwm==255){		/* when hit top, reset and switch direction */
      pwm = 0;
      if (updown == 0){
	updown = 1;
      }
      else{
	updown=0;
      }
    }
    
    if (updown){	       /* going up */
      OCR1AL = pwm;		/* just write values to the register */
      OCR1BL = 255-pwm;
    }
    else{			/* going down */
      OCR1AL = 255-pwm;
      OCR1BL = pwm;  
    }
  }
  else{
    timerClicks++;
  }
}

int main(void){

  uint8_t i;
  
  initLED();
  LED_DDR |= _BV(PB1) | _BV(PB2);	/* output on PB1, PB2 (OC1A, OC1B) */
  initUART();
  sayOK();
  
  /* Configure the timer */
  TCCR1A |= _BV(WGM10);		   /* fast PWM, 8-bit mode (p. 136) */
  TCCR1B |= _BV(WGM12);		   /* fast PWM, 8-bit mode (p. 136 */

  TCCR1B |= _BV(CS12);		/* Divide clock by 1024 (p. 110) */  
  TCCR1A |= _BV(CS10);		/* Divide clock by 1024 (p. 110) */  

  TCCR1A |= _BV(COM1A1);		   /* set to turn off LED when (p. 134) */
  TCCR1A |= _BV(COM1B1);		   /*  set to turn off LED when (p. 134) */

  /* Now replace delay with timer-based routine */
  TIMSK1 |= _BV(TOIE1);
  sei();

  while(1){
    ;
  }	     /* end while */
  return(1);			/* never reached */
}				/* end main */
