/* Using the counter and an interrupt for PWM */

#include <avr/io.h>	      /* Defines pins, ports, etc */
#define F_CPU 8000000UL       /* Sets up the chip speed for delay.h */
#include <util/delay.h>	      /* Functions to waste time */
#define BAUDRATE  9600
#include "USART88.h"	       /* uses BAUDRATE, so define it first */
#include <avr/interrupt.h>
#include "pinDefines.h"
#include "commonInits.h"


int main(void){

  uint8_t i;
  
  initLED();
  LED_DDR |= _BV(PB1) | _BV(PB2);	/* output on PB1, PB2 (OC1A, OC1B) */
  initUART();
  sayOK();
  
  /* Configure the timer */
  TCCR1A |= _BV(WGM10);		   /* fast PWM, 8-bit mode (p. 136) */
  TCCR1B |= _BV(WGM12);		   /* fast PWM, 8-bit mode (p. 136 */

  TCCR1B |= _BV(CS12);		/* Divide clock by 1024 (p. 110) */  
  TCCR1A |= _BV(CS10);		/* Divide clock by 1024 (p. 110) */  

  TCCR1A |= _BV(COM1A1);		   /* set to turn off LED when (p. 134) */
  TCCR1A |= _BV(COM1B1);		   /*  set to turn off LED when (p. 134) */
  

  while(1){
    for (i=0; i<255; i++){	/* now fade in/out */
      OCR1AL = i;		/* just write values to the register */
      OCR1BL = 255-i;
      _delay_ms(2);		/* rest happens in hardware while we wait */
    }
    for (i=0; i<255; i++){
      OCR1AL = 255-i;
      OCR1BL = i;
      _delay_ms(2);
    }
    

  }	     /* end while */
  return(1);			/* never reached */
}				/* end main */
