/* Serial-enabled, interrupt-driven bogus example. */

#include <avr/io.h>	      /* Defines pins, ports, etc */
#define F_CPU 8000000UL       /* Sets up the chip speed for delay.h */
#include <util/delay.h>	      /* Functions to waste time */
#define BAUDRATE  9600
#include "USART88.h"	       /* uses BAUDRATE, so define it first */
#include <avr/interrupt.h>
#include "pinDefines.h"
#include "commonInits.h"

volatile uint8_t serialBuffer[10];
volatile uint8_t bufferFillLevel;


ISR(USART_RX_vect){		/* ISR for receive on USART */
  serialBuffer[bufferFillLevel] = UDR0;	      /* add an extra value into the buffer */
	if (bufferFillLevel < 10){
	  bufferFillLevel++;			
	}
}

int main(void){
  uint8_t i, letter;
  uint8_t whichLED;
  
  initLED();
  LED_DDR = 0xff;
  initUART();
  sayOK();
    
  /* Setup serial interrupt here */
  UCSR0B |= _BV(RXCIE0);        /* turn on receive interrupt vector */
  sei();                        /* set interrupts enable */
  
  while(1){

    for (letter = 'A'; letter <= 'Z'; letter++){ /* this is just something to do */
      transmitByte(letter);      
      _delay_ms(100);		/* Take a long time here, makes the buffer useful */
      _delay_ms(100);
      _delay_ms(100);
      _delay_ms(100);
      _delay_ms(100);
      _delay_ms(100);
      
      if (bufferFillLevel){	/* check if USART buffer full, handle it */
	whichLED++;
	if (whichLED > 7){
	  whichLED = 0;
	}
	LED_PORT = _BV(whichLED);
	bufferFillLevel--;	/* we've "used up" one entry in the buffer */
	/* note: could also handle entire buffer here, clear it each time */
      }
    }
    transmitByte('\r');    	/* carriage return after full alphabet */
    transmitByte('\n');    

  } /* end while */
  return(27);
}   /* end main */
