/* Serial-enabled, interrupt-driven bogus example. */

#include <avr/io.h>	      /* Defines pins, ports, etc */
#define F_CPU 8000000UL       /* Sets up the chip speed for delay.h */
#include <util/delay.h>	      /* Functions to waste time */
#define BAUDRATE  9600
#include "USART88.h"	       /* uses BAUDRATE, so define it first */
#include <avr/interrupt.h>
#include "pinDefines.h"
#include "commonInits.h"

volatile uint8_t whichLED;

ISR(USART_RX_vect){		/* ISR for receive on USART */
  uint8_t serialInput;
  serialInput = UDR0;		/* read in the data, clear the interrupt, p. 189 */

  whichLED++;			/* advance LED on serial receive */
  if (whichLED > 7){
    whichLED = 0;
  }
  LED_PORT = _BV(whichLED);
}


int main(void){
  uint8_t i, letter;
  
  initLED();
  LED_DDR = 0xff;               /* enable output on _all_ LEDs */
  initUART();
  sayOK();
    
  /* Setup serial interrupt here */
  UCSR0B |= _BV(RXCIE0);        /* turn on receive interrupt vector, p. 196 */
  sei();                        /* set interrupts enable */
  
  while(1){

    for (letter = 'A'; letter <= 'Z'; letter++){ /* this is just something to do */
      transmitByte(letter);      
      _delay_ms(100);
      _delay_ms(100);
    }
    transmitByte('\r');    	/* carriage return after full alphabet */
    transmitByte('\n');    

  } /* end while */
  return(27);
}   /* end main */
