#include <avr/io.h>
#include <avr/interrupt.h>
#define F_CPU 1000000UL
#include <util/delay.h>

#define SPEAKEROUT   PB6
#define BUTTON       PB0
#define ADC          PC5	/* ADC 5 */

int main(void){

  uint8_t adcValue;
  uint8_t i;

  DDRB = _BV(SPEAKEROUT);	/* setup speaker for output */
  PORTB = _BV(BUTTON);		/* enable pullup on button */
 
  /* Set up the ADC */
  ADMUX = _BV(MUX0) + _BV(MUX2); /* sample on ADC5, p. 257 */
  ADMUX |= _BV(ADLAR);    /* left-shift for easy 8 bit samples, p. 259 */
  DIDR0 |= _BV(ADC5D);  /* turn off digital input buffer on ADC5, p. 260 */
  ADCSRA = _BV(ADEN) + _BV(ADATE); /* ADC enable, auto-trigger enable p. 258*/
  ADCSRA |= _BV(ADSC); 		/* start conversions */

  while(1){
    _delay_us(10);
    i++;

    if (~PINB & _BV(BUTTON)){
      adcValue = ADCH;
      if (i == adcValue){
	i = 0;
	PORTB ^= _BV(SPEAKEROUT);
      }
    }
  }
  return(1);
}
