/* Demonstrates PC interrupts using the ADC as a binary indicator */

#include <avr/io.h>
#include <avr/interrupt.h>
#define F_CPU 8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"
#include "pinDefines.h"
#include "commonInits.h"

volatile uint8_t itIsBright;

ISR(PCINT1_vect){ 		/* There's been a change! */
  uint8_t i;
  char lightPhrase[] = {'L', 'i' ,'g', 'h','t', '\r', '\n'};
  char darkPhrase[] = {'D','a','r','k','\r','\n'};  

  if (ADC_PIN & _BV(ADC)){	/* read ADC pin as logic level */
    itIsBright = 1;    
    for (i=0; i < sizeof(lightPhrase)/sizeof(char); i++){
      transmitByte(lightPhrase[i]);
    }
  }
  else{
    itIsBright = 0;
    for (i=0; i < sizeof(darkPhrase)/sizeof(char); i++){
      transmitByte(darkPhrase[i]);
    }
  }
}


int main(void){
  
  initLED();
  initUART();
  sayOK();
  initADC();

  // Configure interrupts
  sei();                        /* set interrupts enable */
  PCMSK1 |= _BV(PCINT8); 	/* monitor PCINT8, on PC0 */
  PCICR |= _BV(PCIE1); 		/* enable PC interrupts on port C, p. 73  */


  while(1){

    if (itIsBright){
      LED_ON ;
    }
    else{
      LED_OFF;
    }

  } /* end mainloop */


  return(1);
}

