
/* This code is a demo of a lightweight approach to interrupt service routines */

#include <avr/io.h>
#include <avr/interrupt.h>
#define F_CPU 8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"
#include "pinDefines.h"
#include "commonInits.h"

volatile uint8_t buttonIsPressed; /* This variable is defined outside of the main loop
				   and is declared to be volatile -- it can be changed from within any function.*/ 
				   
ISR(INT0_vect){				/* lightweight interrupt, takes a microsecond? */
  buttonIsPressed = 1;			/* just set variable and return */
}

int main(void){
  
  initLED();
  initUART();
  sayOK();
  initADC();

  // Configure interrupts
  EICRA |= _BV(ISC01); 		/* configure interrupt on falling edge, p. 71 */
  EIMSK |= _BV(INT0); 		/* enable interrupt mask for INT0, p. 72 */
  BUTTON_PORT |= _BV(BUTTON);	/* enable pullup */  
  sei();                        /* set interrupts enable */
  
  while(1){			/* mainloop */
    
    if (buttonIsPressed){	/* handle button presses in main loop */
      _delay_ms(50);		/* simple debounce */
      if ((BUTTON_PIN & _BV(BUTTON)) == 0){ /* still low after delay */
	      LED_PORT |= _BV(LED);
	      transmitByte(ADCH);
	      _delay_ms(100);
	      LED_PORT &= ~_BV(LED);	
	
	      buttonIsPressed = 0;	/* remember to reset variable once it's been handled */
      }    
    }
    
  }                             /* end mainloop */
  return(0);
}
