
/* This code is a demo of a heavy approach to interrupt service routines */

#include <avr/io.h>
#include <avr/interrupt.h>
#define F_CPU 8000000UL
#include <util/delay.h>
#define BAUDRATE 9600
#include "USART88.h"
#include "pinDefines.h"
#include "commonInits.h"

ISR(INT0_vect){				/* heavyweight interrupt -- takes 100ms */
  transmitByte(ADCH);
  LED_PORT |= _BV(LED);
  _delay_ms(100); 		 /* this delay is like a sneaky debounce routine */
  LED_PORT &= ~_BV(LED); /* but nothing else can happen while we're waiting */
}


int main(void){
  
  // Inits
  initLED();
  initUART();
  sayOK();
  initADC();

  // Configure interrupts
  EIMSK |= _BV(INT0); 		/* enable interrupt mask for INT0 */
  BUTTON_PORT |= _BV(BUTTON);	/* enable pullup */
  sei();                        /* set interrupts enable */
  
  
  while(1){			/* mainloop */
    ; 				/* do absolutely nothing! */
  }                             /* end mainloop */
  return(0);
}

